<?php

return array(

    'name' => 'widget/youtube-list',

    'main' => 'YOOtheme\\Widgetkit\\Widget\\Widget',

    'config' => array(

        'name'  => 'youtube-list',
        'label' => 'Youtube List',
        'core'  => false,
        'icon'  => 'plugins/widgets/youtube-list/widget.svg',
        'view'  => 'plugins/widgets/youtube-list/views/widget.php',
        'item'  => array('title', 'content', 'media', 'link'),
        'settings' => array(
            'gutter' 				=> 'small',
			'column_align' 			=> 'left',
			'column_width' 			=> '2-3',
			'column_breakpoint' 	=> 'medium',
			'autoplay' 				=> false,
			'listautoplay' 			=> true,
			'start' 				=> 0,

            'media' 				=> true,
            'image_width' 			=> 'auto',
            'image_height' 			=> 'auto',
            'media_align' 			=> 'left',
            'media_width' 			=> '2-5',
            'media_breakpoint' 		=> 'phone',
            'content_align' 		=> false,

            'title' 				=> true,
            'content' 				=> false,
			'title_size' 			=> 'h6',

            'class' 				=> ''
        )

    ),

    'events' => array(

        'init.site' => function($event, $app) {
			$app['scripts']->add('uikit-youtube', 'plugins/widgets/youtube-list/assets/youtube.js', array('uikit'));
        },

        'init.admin' => function($event, $app) {
            $app['angular']->addTemplate('youtube-list.edit', 'plugins/widgets/youtube-list/views/edit.php', true);
			
			$app->extend('translator', function ($translator, $app) {
    	        return $translator->addResource('plugins/widgets/youtube-list/languages/'.$app['locale'].'.json');
	        });
        }

    )

);
