<?php

// Id
$settings['id'] = substr(uniqid(), -3);

// JS Options
$options = array();
$playerVars = array();
$options[] = ($settings['start']) ? 'start:' . $settings['start'] : '';
$options[] = (!$settings['listautoplay']) ? 'listautoplay: false' : '';
$playerVars[] = ($settings['autoplay']) ? 'autoplay:true' : '';
$options[] = (count(array_filter($playerVars))) ? 'playerVars:{'.implode(', ', array_filter($playerVars)).'}' : '';
$options = '{'.implode(', ', array_filter($options)).'}';

$grid = 'uk-grid';
$grid .= ($settings['gutter'] == 'collapse') ? ' uk-grid-collapse' : '' ;
$grid .= ($settings['gutter'] == 'small') ? ' uk-grid-small' : '' ;
$grid .= ($settings['gutter'] == 'medium') ? ' uk-grid-medium' : '' ;

// Column Width
$column_width = 'uk-width-' . $settings['column_breakpoint'] . '-' . $settings['column_width'];

switch ($settings['column_width']) {
    case '2-3':
        $list_width = '1-3';
        break;
}

$list_width = 'uk-width-' . $settings['column_breakpoint'] . '-' . $list_width;

// Content Align
$list_align  = $settings['column_align'] ? 'uk-flex-middle' : '';

// Media Width
$settings['media_breakpoint'] = $settings['media_breakpoint'] == 'phone' ? '' : $settings['media_breakpoint'].'-';
$media_width = 'uk-width-' . $settings['media_breakpoint'] . $settings['media_width'];

switch ($settings['media_width']) {
    case '1-5':
        $content_width = '4-5';
        break;
    case '1-4':
        $content_width = '3-4';
        break;
    case '3-10':
        $content_width = '7-10';
        break;
    case '1-3':
        $content_width = '2-3';
        break;
    case '2-5':
        $content_width = '3-5';
        break;
    case '1-2':
        $content_width = '1-2';
        break;
}

$content_width = 'uk-width-' . $settings['media_breakpoint'] . $content_width;

// Content Align
$content_align  = $settings['content_align'] ? 'uk-flex-middle' : '';

// Title Size
switch ($settings['title_size']) {
    case 'panel':
        $title_size = 'uk-panel-title';
        break;
    case 'large':
        $title_size = 'uk-heading-large uk-margin-top-remove';
        break;
    default:
        $title_size = 'uk-' . $settings['title_size'] . ' uk-margin-top-remove';
}
?>

<div class="yt-container <?php echo $settings['class']; ?>" data-uk-youtube="<?php echo $options; ?>">
    
    <div class="<?php echo $grid;?>" data-uk-grid-margin data-uk-grid-match="{> div > .uk-panel}">
    
        <div class="<?php echo $column_width ?><?php if ($settings['column_align'] == 'right') echo ' uk-float-right uk-flex-order-last-' . $settings['column_breakpoint'] ?>">
            <div class="uk-panel yt-panel-iframe">
                <div class="uk-slidenav-position">
                    <div class="tm-iframe-container">
                        <div id="yt-video-player" data-uk-youtube-id="<?php echo $items[($settings['start']) ? $settings['start'] : 0]['video_id'];?>"></div>
                    </div>
                    <a href="" class="uk-slidenav uk-slidenav-contrast uk-slidenav-previous" data-uk-youtube-item="previous"></a>
                    <a href="" class="uk-slidenav uk-slidenav-contrast uk-slidenav-next" data-uk-youtube-item="next"></a>
                </div>
            </div>
        </div>
        
        <div class="<?php echo $list_width;?>">
            <div class="uk-panel yt-panel-list">
                <ul class="uk-list uk-youtube-list">
                    <?php foreach ($items as $i => $item)
                    {
                        // Media Type
                        $attrs  = array('class' => '');
                        $width  = $item['media.width'];
                        $height = $item['media.height'];
                        
                        if ($item->type('media') == 'image') {
                            $attrs['alt'] = strip_tags($item['title']);
                            $width  = ($settings['image_width'] != 'auto') ? $settings['image_width'] : $width;
                            $height = ($settings['image_height'] != 'auto') ? $settings['image_height'] : $height;
                        }
                        
                        $attrs['width']  = ($width) ? $width : '';
                        $attrs['height'] = ($height) ? $height : '';
                        
                        if (($item->type('media') == 'image') && ($settings['image_width'] != 'auto' || $settings['image_height'] != 'auto')) {
                            $media = $item->thumbnail('media', $width, $height, $attrs);
                        } else {
                            $media = $item->media('media', $attrs);
                        }
                        ?>
                        <li class="uk-panel" data-uk-youtube-item="<?php echo $i;?>" data-uk-youtube-id="<?php echo $item['video_id'];?>">
                            
                            <div>
                                <?php if ($item['media'] && $settings['media'] && in_array($settings['media_align'], array('teaser', 'top'))) : ?>
                                <div class="uk-text-center <?php echo (($settings['media_align'] == 'teaser') ? 'uk-panel-teaser' : 'uk-margin uk-margin-top-remove'); ?>"><?php echo $media; ?></div>
                                <?php endif; ?>
                                
                                <?php if ($item['media'] && $settings['media'] && in_array($settings['media_align'], array('left', 'right'))) : ?>
                                <div class="uk-grid uk-grid-small <?php echo $content_align; ?>" data-uk-grid-margin>
                                    <div class="<?php echo $media_width ?><?php if ($settings['media_align'] == 'right') echo ' uk-float-right uk-flex-order-last-' . $settings['media_breakpoint'] ?>">
                                        <?php echo $media; ?>
                                    </div>
                                    <div class="<?php echo $content_width ?>">
                                        <div class="uk-panel">
                                <?php endif; ?>
                    
                                <?php if ($item['title'] && $settings['title']) : ?>
                                <h3 class="<?php echo $title_size; ?> yt-panel-title"><?php echo $item['title']; ?></h3>
                                <?php endif; ?>
                                
                                <?php if ($item['media'] && $settings['media'] && $settings['media_align'] == 'bottom') : ?>
                                <div class="uk-margin uk-text-center"><?php echo $media; ?></div>
                                <?php endif; ?>
                    
                                <?php if ($item['content'] && $settings['content']) : ?>
                                <div class="uk-margin"><?php echo $item['content']; ?></div>
                                <?php endif; ?>
                                
                                <?php if ($item['media'] && $settings['media'] && in_array($settings['media_align'], array('left', 'right'))) : ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </li>
                    <?php
                    }?>
                </ul>
            </div>
        </div>
    
    </div>

</div>