<?php
/* Load Joomla
***************************************************************************************/
define('JOOMLA_MINIMUM_PHP', '5.3.10');

if (version_compare(PHP_VERSION, JOOMLA_MINIMUM_PHP, '<'))
{
	die('Your host needs to use PHP ' . JOOMLA_MINIMUM_PHP . ' or higher to run this version of Joomla!');
}

define('_JEXEC', 1);

if (file_exists(__DIR__ . '/defines.php'))
{
	include_once __DIR__ . '/defines.php';
}

if (!defined('_JDEFINES'))
{
	define('JPATH_BASE', __DIR__);
	require_once JPATH_BASE . '/includes/defines.php';
}

require_once JPATH_BASE . '/includes/framework.php';

// Mark afterLoad in the profiler.
JDEBUG ? $_PROFILER->mark('afterLoad') : null;

// Instantiate the application.
$app = JFactory::getApplication('site');

// Execute the application.
$app->initialise();

/* End load joomla
***************************************************************************************/

// Class Virtuemart import
class importVM
{
	private $_items = array();
	private $_header = array();
	private $_file = '';
	private $_log = array();
	private $_csv_files = array();
	
	public function __construct($file)
	{
		$this->_file = $file;
		$this->_loadFile($file);
    }
	
	public function print_r($array){ echo '<pre>'; print_r($array); echo '</pre>'; }
	public function getHeader(){ return $this->_header; }
	public function getItems(){ return $this->_items; }
	public function getTotal(){ return count($this->_items); }
	public function getLog(){ return $this->_log; }
	
	public function addLog($key = 'system', $type = 'info', $message = '')
	{
		if(!array_key_exists($key, $this->_log))
		{
			$this->_log[$key] = array();
		}
		
		if(!array_key_exists($type, $this->_log[$key]))
		{
			$this->_log[$key][$type] = array();
		}
		
		$this->_log[$key][$type][] = $message;
		
	}
	
	public function getChildren($virtuemart_product_id)
	{
		$items = array();
		
		foreach($this->_items as $item)
		{
			if($item->get('product_parent_id') == $virtuemart_product_id) $items[] = $item;
		}
		
		return $items;
	}
	
	public function getCustomMultiVariants($product)
	{

		$virtuemart_product_id = $product->get('virtuemart_product_id', 0);

		$items = $this->getChildren($virtuemart_product_id);
		$tmp_options = array($virtuemart_product_id => array("0", "0"));
		$tmp_selectoption = array();

		$customs = array();
		foreach($product->get('product_customfields', array()) as $custom_name => $custom)
		{
			if(!$custom){
				$this->addLog('getCustomMultiVariants', 'alert', 'Skip: Empty custom value. product id: ' . $item->get('virtuemart_product_id', 0) );
				continue;
			}
			
			$customs[] = $custom;
			
			if(!array_key_exists($custom_name, $tmp_selectoption))
			{
				$tmp_selectoption[$custom_name] = array();
			}
			
			$tmp_selectoption[$custom_name][] = $custom;
		}

		$tmp_options[$product->get('virtuemart_product_id')] = $customs;
						
		foreach($items as $item)
		{
			$customs = array();
			foreach($item->get('product_customfields', array()) as $custom_name => $custom)
			{
				if(!$custom){
					$this->addLog('getCustomMultiVariants', 'alert', 'Skip: Empty custom value. product id: ' . $item->get('virtuemart_product_id', 0) );
					continue;
				}
				
				$customs[] = $custom;
				
				if(!array_key_exists($custom_name, $tmp_selectoption))
				{
					$tmp_selectoption[$custom_name] = array();
				}
				
				$tmp_selectoption[$custom_name][] = $custom;
			}
			
			$tmp_options[$item->get('virtuemart_product_id')] = $customs;
		}
		
		$tmp_selectoptions = array();
		foreach($tmp_selectoption as $key => $selectoption)
		{
			$tmp_selectoptions[] = array('voption' => 'clabels', 'clabel' => $key, 'values' => implode("\r\n", array_unique($selectoption)));
		}
		
		$options = new stdClass();
		$options->selectoptions = $tmp_selectoptions;
		$options->options = $tmp_options;
		
		return $options;
	}
	
	private function _loadFile($file)
	{			
		if (($file = fopen($file, "r")) !== FALSE)
		{
			while (($csv = fgetcsv($file, 1000, ",")) !== FALSE)
			{
				$columns = count($csv);
				$column = array();
							
				for ($c = 0; $c < $columns; $c++)
				{
					$column[] = trim($csv[$c]);
				}
				
				$row = new  JRegistry(); // new stdClass();
				$row->set('columns', $column );
				
				$this->_items[] = $row;
			}
			
			fclose($file);
		}
		
		if(count($this->_items) > 0 ) $this->_header = array_shift( $this->_items );
				
	}
		
	public function download_csv($items = array(), $filename = 'items', $attachment = true, $delimiter = ",", $enclosure = '"')
	{
		if($attachment)
		{
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename="'.$filename.'.csv"');
		}
		
		$out = fopen('php://output', 'w');

		foreach($items as $item)
		{
			fputcsv($out, $item, $delimiter, $enclosure);
		}

		fclose($out);
	}
	
	public function add_csv($items = array(), $filename = 'items', $delimiter = ",", $enclosure = '"')
	{
		$out = fopen('php://temp/maxmemory:1048576', 'w');

		foreach($items as $item)
		{
			fputcsv($out, $item, $delimiter, $enclosure);
		}
		
		rewind($out);
		
		$this->_csv_files[$filename.'.csv'] = stream_get_contents($out);

		fclose($out);
	}
	
	public function download_zip($zip_filename_stub = 'virtuemart' )
	{
		$zip_filename = preg_replace('/[^a-zA-Z0-9]/', '', $zip_filename_stub) . '.zip';
		$temp_filename = tempnam(sys_get_temp_dir(), $zip_filename);
	 
		$zip = new ZipArchive();
	 
		if (TRUE !== ($zip_open_code = $zip->open($temp_filename, ZipArchive::CREATE)))
		{
			exit();
		}
	 
		foreach ($this->_csv_files as $filename => $content)
		{
			$zip->addFromString($filename, $content);
		}
	 
		if (TRUE !== $zip->close())
		{
			exit();
		}
	 
		header('Content-Type: application/zip');
		header('Content-Disposition: attachment; filename=' . $zip_filename);
		header('Content-Length: ' . filesize($temp_filename));
	 
		readfile($temp_filename);
	 
		// Delete temporary .zip file created
		unlink($temp_filename);
	 
		exit();
	}
}

// Export Data
$datos = new importVM("productos.csv");
$global_created_on = '2017-11-08 00:00:00';
$global_created_by = 721;

// Set product basic fields
foreach($datos->getItems() as $item)
{
	$columns = $item->get('columns',  	array());
	
	$item->set('virtuemart_product_id', $columns[0]);
	$item->set('product_parent_id', 	0);
	$item->set('product_sku', 			$columns[3]);
	$item->set('product_gtin', 			'');
	$item->set('product_name', 			$columns[1]);
	$item->set('slug', 					JFilterOutput::stringURLSafe($columns[2]));
	$item->set('product_length',		'NULL'); 	// 'NULL'
	$item->set('product_width',			'NULL'); 	// 'NULL'
	$item->set('product_height',		'NULL'); 	// 'NULL'
	$item->set('product_lwh_uom',		'CM'); 			// 'M'
	$item->set('product_unit',			'KG'); 		// 'KG'
	$item->set('product_packaging',		'NULL'); 	// 'NULL'
	$item->set('product_params',		'min_order_level=""|max_order_level=""|step_order_level=""|product_box=""|');
	$item->set('product_in_stock',		$columns[12]);
	$item->set('product_s_desc', 		'');
	$item->set('product_desc', 			$columns[10]);
	$item->set('product_available_date',$global_created_on);
	$item->set('created_on',			$global_created_on);
	$item->set('created_by',			$global_created_by);
	$item->set('product_currency',		144);
	$item->set('product_prices',		array_filter( array(0 => $columns[7])) );
	$item->set('product_prices2',		'');
	$item->set('product_categories',	array_filter( array($columns[4], $columns[5], $columns[6])) );
	$item->set('product_medias',		array_filter( array($columns[13], $columns[14], $columns[15])));
	$item->set('product_manufactur',	'');
	
	// Variants customfields
	//$item->set('product_customfields',	array_filter( array('Talle' => $columns[11], 'Color' => $columns[13], 'Tipo' => $columns[15]) ));
	$item->set('product_customfields_2',array_filter( array('3' => $columns[9])));
	// Filters or simple customfield
	
}

/* virtuemart_medias
***************************************************************************************/
$defaults = array(
	'virtuemart_media_id' 	=> 0,
	'virtuemart_vendor_id'	=> 1,
	'file_title' 			=> '',
	'file_description'		=> '',
	'file_meta' 			=> '',
	'file_class' 			=> '',
	'file_mimetype'			=> 'image/jpeg',
	'file_type' 			=> 'product',
	'file_url' 				=> 'images/virtuemart/product',
	'file_url_thumb' 		=> '',
	'file_is_product_image' => 0,
	'file_is_downloadable' 	=> 0,
	'file_is_forSale' 		=> 0,
	'file_params' 			=> '',
	'file_lang' 			=> '',
	'shared' 				=> 0,
	'published' 			=> 1,
	'created_on' 			=> $global_created_on,
	'created_by' 			=> $global_created_by,
	'modified_on' 			=> '0000-00-00 00:00:00',
	'modified_by' 			=> 0,
	'locked_on' 			=> '0000-00-00 00:00:00',
	'locked_by' 			=> 0
);

$items = array(array_keys($defaults));
$product_medias = array();
$autoincrement = 1;

// Add vendor media
$vendor_media_row = array( 'virtuemart_media_id' => $autoincrement++, 'virtuemart_vendor_id' => 1, 'file_title' => 'logo.png', 'file_description' => '', 'file_meta' => '', 'file_class' => '', 'file_mimetype' => 'image/jpeg', 'file_type' => 'vendor', 'file_url' => 'images/virtuemart/vendor/logo.png', 'file_url_thumb' => '', 'file_is_product_image' => 0, 'file_is_downloadable' => 0, 'file_is_forSale' => 0, 'file_params' => '', 'file_lang' => '', 'shared' => 0, 'published' => 1, 'created_on' => $global_created_on, 'created_by' => $global_created_by, 'modified_on' => '0000-00-00 00:00:00', 'modified_by' => 0, 'locked_on' => '0000-00-00 00:00:00', 'locked_by' => 0);
$items[] = array_values($vendor_media_row);
$datos->addLog('virtuemart_medias', 'success', 'Add Vendor Media: logo.png ');

$orden = array();
foreach($datos->getItems() as $aux){
	$orden[$aux->get('virtuemart_product_id',0)] = 0; 
}

foreach($datos->getItems() as $item)
{	
	foreach($item->get('product_medias', array()) as $media)
	{
		if(!$media){
			$datos->addLog('virtuemart_medias', 'info', 'Skip: Empty Media. product id: ' . $item->get('virtuemart_product_id', 0) );
			continue;
		}
		
		
		$row = array();
		foreach($defaults as $key => $default)
		{
			if($key == 'virtuemart_media_id'){
				$virtuemart_media_id = $autoincrement++;
				$row[] = $virtuemart_media_id;
			}else if($key == 'file_title'){
				$row[] = $media;
			}else if($key == 'file_url'){
				$row[] = $defaults[$key].'/'.$media;
			}else{
				$row[] = $item->get($key, $defaults[$key]);
			}
		}
		
		$product_medias[] = array('virtuemart_product_id' => $item->get('virtuemart_product_id', 0), 'virtuemart_media_id' => $virtuemart_media_id);
		$items[] = $row;
		$datos->addLog('virtuemart_medias', 'success', 'Add: Media: '.$media.', product id: ' . $item->get('virtuemart_product_id', 0) );
	}
}

$datos->add_csv($items, 'virtuemart_medias');

/* virtuemart_product_medias
***************************************************************************************/
$defaults = array(
	'id' 					=> 0,
	'virtuemart_product_id'	=> 0,
	'virtuemart_media_id' 	=> 0,
	'ordering' 				=> 0
);

$items = array(array_keys($defaults));
$autoincrement = 1;

foreach($product_medias as $product_media)
{
	$items[] = array($autoincrement++, $product_media['virtuemart_product_id'], $product_media['virtuemart_media_id'], $orden[$product_media['virtuemart_product_id']]++);
	$datos->addLog('virtuemart_product_medias', 'success', 'Add: Media id: '.$product_media['virtuemart_media_id'].', Product id: '.$product_media['virtuemart_product_id']);
}

$datos->add_csv($items, 'virtuemart_product_medias');

/* virtuemart_product_categories
***************************************************************************************/
$defaults = array('id' => 0, 'virtuemart_product_id' => 0, 'virtuemart_category_id' => '', 'ordering' => 0);
$items = array(array_keys($defaults));
$autoincrement = 1;

foreach($datos->getItems() as $item)
{
	if($item->get('product_parent_id', 0) != '0')
	{
		$datos->addLog('virtuemart_product_categories', 'info', 'Skip: Child product. child id: ' . $item->get('virtuemart_product_id', 0) );
		continue;
	}

	$product_categories = $item->get('product_categories', array());
		
	foreach($product_categories as $key_catgory => $category)
	{
		if(!$category){
			$datos->addLog('virtuemart_product_categories', 'info', 'Skip: Empty Category. product id: ' . $item->get('virtuemart_product_id', 0) );
			continue;
		}
		
		$row = array();
		$product_categories_s = $product_categories;

		foreach($defaults as $key => $default)
		{
			if($key == 'id'){
				$row[] = $autoincrement++;
			}else if($key == 'virtuemart_category_id'){
				$row[] = implode('///', array_slice($product_categories_s, 0, $key_catgory+1));
			}else{
				$row[] = $item->get($key, $defaults[$key]);
			}
		}
		
		$items[] = $row;
		$datos->addLog('virtuemart_product_categories', 'success', 'Add Category: '.$category.', product id: ' . $item->get('virtuemart_product_id', 0) );
	}
}

$datos->add_csv($items, 'virtuemart_product_categories');

/* virtuemart_product_customfields_2
***************************************************************************************/
$defaults = array(
	'virtuemart_customfield_id' => 0,
	'virtuemart_product_id' 	=> 0,
	'virtuemart_custom_id' 		=> 'vm_custom_id',
	'customfield_value' 		=> 'NULL',
	'customfield_price' 		=> 'NULL',
	'disabler' 					=> 0,
	'override' 					=> 0,
	'customfield_params' 		=> '',
	'product_sku' 				=> 'NULL',
	'product_gtin' 				=> 'NULL',
	'product_mpn' 				=> 'NULL',
	'published' 				=> 0,
	'created_on' 				=> $global_created_on,
	'created_by' 				=> $global_created_by,
	'modified_on' 				=> '0000-00-00 00:00:00',
	'modified_by' 				=> 0,
	'locked_on' 				=> '0000-00-00 00:00:00',
	'locked_by' 				=> 0,
	'ordering' 					=> 0,
);

$items = array(array_keys($defaults));
$autoincrement = 1;

foreach($datos->getItems() as $item)
{	
	$product_customfields_2 = $item->get('product_customfields_2', array());

	foreach ($product_customfields_2 as $custom_name => $custom_value)
	{
		if($custom_name == 'Modelo id: 3')
		{
			$custom_value_items = explode(',', $custom_value);

			foreach ($custom_value_items as $custom_value_items_key => $custom_value_items_value)
			{
				$row = array();
			
				foreach($defaults as $key => $default)
				{
					if($key == 'virtuemart_customfield_id'){ $row[] = $autoincrement++; }
					elseif($key == 'product_sku') { $row[] = 'NULL'; }
					elseif($key == 'product_gtin') { $row[] = 'NULL'; }
					elseif($key == 'virtuemart_custom_id') { $row[] = $custom_name; }
					elseif($key == 'customfield_value') { $row[] = trim($custom_value_items_value); }
					else{ $row[] = $item->get($key, $defaults[$key]); }
				}

				$items[] = $row;

				$datos->addLog('virtuemart_product_customfields_2', 'success', 'Add Custom Field: '.$custom_name.', product id: ' . $item->get('virtuemart_product_id', 0) );
			}
		}
		else
		{
			$row = array();

			foreach($defaults as $key => $default)
			{
				if($key == 'virtuemart_customfield_id'){ $row[] = $autoincrement++; }
				elseif($key == 'product_sku') { $row[] = 'NULL'; }
				elseif($key == 'product_gtin') { $row[] = 'NULL'; }
				elseif($key == 'virtuemart_custom_id') { $row[] = $custom_name; }
				elseif($key == 'customfield_value') { $row[] = trim($custom_value); }
				else{ $row[] = $item->get($key, $defaults[$key]); }
			}

			$items[] = $row;

			$datos->addLog('virtuemart_product_customfields_2', 'success', 'Add Custom Field: '.$custom_name.', product id: ' . $item->get('virtuemart_product_id', 0) );
		}
	}
}

$datos->add_csv($items, 'virtuemart_product_customfields_2', "^", "*");

/* virtuemart_product_customfields
***************************************************************************************/
$defaults = array(
	'virtuemart_customfield_id' => 0,
	'virtuemart_product_id' 	=> 0,
	'virtuemart_custom_id' 		=> 12,
	'customfield_value' 		=> 'NULL',
	'customfield_price' 		=> 'NULL',
	'disabler' 					=> 0,
	'override' 					=> 0,
	'customfield_params' 		=> 'usecanonical=0|showlabels=0|sCustomId=0|selectoptions=0|clabels=0|options=0|',
	'product_sku' 				=> 'NULL',
	'product_gtin' 				=> 'NULL',
	'product_mpn' 				=> 'NULL',
	'published' 				=> 0,
	'created_on' 				=> $global_created_on,
	'created_by' 				=> $global_created_by,
	'modified_on' 				=> '0000-00-00 00:00:00',
	'modified_by' 				=> 0,
	'locked_on' 				=> '0000-00-00 00:00:00',
	'locked_by' 				=> 0,
	'ordering' 					=> 0,
);

$items = array(array_keys($defaults));
$autoincrement = 1;

foreach($datos->getItems() as $item)
{
	if($item->get('product_parent_id', 0) != '0'){
		$datos->addLog('virtuemart_product_customfields', 'info', 'Skip: Child product. child id: ' . $item->get('virtuemart_product_id', 0) );
		continue;
	}
	
	$custom_multivariants = $datos->getCustomMultiVariants($item);
	
	if (!count($custom_multivariants->selectoptions)){
		$datos->addLog('virtuemart_product_customfields', 'info', 'Skip: Empty Multi Variants. product id: ' . $item->get('virtuemart_product_id', 0) );
		continue;
	}
	
	$row = array();
			
	foreach($defaults as $key => $default)
	{
		if($key == 'virtuemart_customfield_id'){
			$row[] = $autoincrement++;
		}else if($key == 'customfield_params'){
			$row[] = "selectoptions=".json_encode($custom_multivariants->selectoptions, JSON_PRETTY_PRINT)."|options=".json_encode($custom_multivariants->options, JSON_PRETTY_PRINT)."|";
		}else{
			$row[] = $item->get($key, $defaults[$key]);
		}
	}
	
	$items[] = $row;
	$datos->addLog('virtuemart_product_customfields', 'success', 'Add Multi Variants: '.json_encode($custom_multivariants->selectoptions, JSON_PRETTY_PRINT).', product id: ' . $item->get('virtuemart_product_id', 0) );
}

$datos->add_csv($items, 'virtuemart_product_customfields', "^", "*");

/* virtuemart_product_manufacturers
***************************************************************************************/
$defaults = array(
	'id' 							=> 0,
	'virtuemart_product_id' 		=> 0,
	'virtuemart_manufacturer_id' 	=> 0
);

$items = array(array_keys($defaults));
$autoincrement = 1;

foreach($datos->getItems() as $item)
{
	if($item->get('product_parent_id', 0) != '0')
	{
		$datos->addLog('virtuemart_product_manufacturers', 'info', 'Skip: Child product. child id: ' . $item->get('virtuemart_product_id', 0) );
		continue;
	}

	if(!$item->get('product_manufactur')) continue;

	$items[] = array($autoincrement++, $item->get('virtuemart_product_id', 0), $item->get('product_manufactur'));
	$datos->addLog('virtuemart_product_manufacturers', 'success', 'Add: Manufacturer id: ' . $item->get('product_manufactur') . ', Product id: ' . $item->get('virtuemart_product_id', 0));
}

$datos->add_csv($items, 'virtuemart_product_manufacturers');

/* virtuemart_product_prices
***************************************************************************************/
$defaults = array(
	'virtuemart_product_price_id' 	=> 0,
	'virtuemart_product_id'			=> 0,
	'virtuemart_shoppergroup_id' 	=> 0,
	'product_price' 				=> '',
	'override' 						=> 0,
	'product_override_price' 		=> '0.00000',
	'product_tax_id' 				=> 0,
	'product_discount_id' 			=> 0,
	'product_currency' 				=> 144,
	'product_price_publish_up' 		=> '0000-00-00 00:00:00',
	'product_price_publish_down' 	=> '0000-00-00 00:00:00',
	'price_quantity_start' 			=> 0,
	'price_quantity_end' 			=> 0,
	'created_on' 					=> $global_created_on,
	'created_by' 					=> $global_created_by,
	'modified_on' 					=> '0000-00-00 00:00:00',
	'modified_by' 					=> 0,
	'locked_on' 					=> '0000-00-00 00:00:00',
	'locked_by' 					=> 0
);

$items = array(array_keys($defaults));
$autoincrement = 1;

foreach($datos->getItems() as $item)
{
	foreach($item->get('product_prices', array()) as $shoppergroup_id => $price)
	{
		if(!$price || $price == '0.000000'){
			$datos->addLog('virtuemart_product_prices', 'info', 'Skip: Empty Price or 0. product id: ' . $item->get('virtuemart_product_id', 0) );
			continue;
		}
		
		$row = array();
		foreach($defaults as $key => $default)
		{
			if($key == 'virtuemart_product_price_id'){
				$row[] = $autoincrement++;
			}else if($key == 'product_price'){
				$row[] = $price;
			}else if($key == 'virtuemart_shoppergroup_id'){
				$row[] = $shoppergroup_id;
			}else if($key == 'override' && $item->get('product_prices2', 0)){
				$row[] = 1;
			}else if($key == 'product_override_price' && $item->get('product_prices2', 0)){
				$row[] = $item->get('product_prices2', 0);
			}else{
				$row[] = $item->get($key, $defaults[$key]);
			}
		}


		
		$items[] = $row;
		$datos->addLog('virtuemart_product_prices', 'success', 'Add Price: product id: ' . $item->get('virtuemart_product_id', 0) );
	}
}

$datos->add_csv($items, 'virtuemart_product_prices');

/* virtuemart_products
***************************************************************************************/
$defaults = array(
	'virtuemart_product_id' 	=> 0,
	'virtuemart_vendor_id' 		=> 1,
	'product_parent_id' 		=> 0,
	'product_sku' 				=> '',
	'product_gtin' 				=> '',
	'product_mpn' 				=> '',
	'product_weight' 			=> 'NULL',
	'product_weight_uom' 		=> 'KG',
	'product_length' 			=> 'NULL',
	'product_width' 			=> 'NULL',
	'product_height' 			=> 'NULL',
	'product_lwh_uom' 			=> 'M',
	'product_url' 				=> '',
	'product_in_stock' 			=> 0,
	'product_stockhandle'		=> 0,
	'product_ordered' 			=> 0,
	'low_stock_notification' 	=> 0,
	'product_available_date' 	=> $global_created_on,
	'product_availability' 		=> '',
	'product_special' 			=> 0,
	'product_discontinued'		=> 0,
	'product_sales' 			=> 0,
	'product_unit' 				=> 'KG',
	'product_packaging' 		=> 'NULL',
	'product_params' 			=> 'min_order_level=""|max_order_level=""|step_order_level=""|product_box=""|',
	'hits' 						=> 'NULL',
	'intnotes' 					=> '',
	'metarobot' 				=> '',
	'metaauthor' 				=> '',
	'layout' 					=> 0,
	'published' 				=> 1,
	'pordering' 				=> 0,
	'created_on' 				=> $global_created_on,
	'created_by' 				=> $global_created_by,
	'modified_on' 				=> '0000-00-00 00:00:00',
	'modified_by' 				=> 0,
	'locked_on' 				=> '0000-00-00 00:00:00',
	'locked_by' 				=> 0
);

$items = array(array_keys($defaults));

foreach($datos->getItems() as $item)
{
	$row = array();
	foreach($defaults as $key => $default){
		$row[] = $item->get($key, $defaults[$key]);
	}
	$items[] = $row;
	$datos->addLog('virtuemart_products', 'success', 'Add Product: product id: ' . $item->get('virtuemart_product_id', 0) );
}

$datos->add_csv($items, 'virtuemart_products');

/* virtuemart_products_es_es.csv
***************************************************************************************/
$defaults = array(
	'virtuemart_product_id' => 0,
	'product_s_desc' => '',
	'product_desc' => '',
	'product_name' => '',
	'metadesc' => '',
	'metakey' => '',
	'customtitle' => '',
	'slug' => ''
);

$items = array(array_keys($defaults));

foreach($datos->getItems() as $item)
{
	$row = array();
	foreach($defaults as $key => $default){
		$row[] = $item->get($key, $defaults[$key]);
	}
	$items[] = $row;
	$datos->addLog('virtuemart_products_es_es', 'success', 'Add Product: product id: ' . $item->get('virtuemart_product_id', 0) );
}

$datos->add_csv($items, 'virtuemart_products_es_es', "^", "*");

/* LOGS
***************************************************************************************/
$datos->download_zip(); return;

$log_color = array('success' => '#00B200', 'alert' => '#ff0000', 'info' => '#007FFF');
foreach($datos->getLog() as $table => $logs)
{
	echo '<h2>'.$table.'</h2>';echo '<hr />';
	
	foreach($logs as $type => $messages)
	{
		echo '<h3>'.$type.'</h3>';
		echo '<div style="overflow: auto; max-height: 200px; max-width: 550px;">';
		foreach($messages as $message ){
			echo '<div style="color: '.$log_color[$type].'">'.$message.'</div>';
		}
		echo '</div>';
	}
	
}

